<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\coveo_secured_search\Annotation\CoveoCustomSecurityProvider as CoveoCustomSecurityProviderAnnotation;
use Drupal\coveo_secured_search\Attribute\CoveoCustomSecurityProvider;

/**
 * Coveo custom security provider plugin manager.
 *
 * Provides a method for replacing various security provider strategies.
 *
 * @see https://docs.coveo.com/en/atomic/latest/usage/#use-components-to-create-a-search-interface
 * @see https://docs.coveo.com/en/1718/manage-an-organization/manage-api-keys#api-key-templates
 * @see https://docs.coveo.com/en/56/build-a-search-ui/use-search-token-authentication
 */
class CoveoCustomSecurityProviderManager extends DefaultPluginManager implements CoveoCustomSecurityProviderManagerInterface {

  /**
   * Construct a security provider manager.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/Coveo/CustomSecurityProvider',
      $namespaces,
      $module_handler,
      CoveoCustomSecurityProviderPluginInterface::class,
      CoveoCustomSecurityProvider::class,
      CoveoCustomSecurityProviderAnnotation::class
    );
    $this->setCacheBackend($cache_backend, 'coveo_custom_security_provider');
  }

}
