<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Plugin;

use Drupal\coveo\Plugin\CoveoSecurityProviderPluginInterface;

/**
 * Provides an interface for Coveo custom security provider plugins.
 */
interface CoveoCustomSecurityProviderPluginInterface extends CoveoSecurityProviderPluginInterface {

  /**
   * Get the identity name from the SearchAPI ID.
   *
   * Note this method is needed to convert SearchAPI's id into the "name" that
   * Coveo will use to identity the user. It needs to match the format that will
   * be used for token generation based on that account.
   *
   * Additionally, we're limited to only the ID because SearchAPI only providers
   * the ID during the delete operation. Since the identity name is the only
   * value that can be used to delete and identity, this has to match.
   *
   * @param string $id
   *   Search API Item ID.
   *
   * @return string
   *   Coveo identity name.
   */
  public function getNameFromId(string $id): string;

}
