<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Retrieves block plugin definitions for all content blocks.
 */
class CustomSecurityProviderDeriver extends DeriverBase implements ContainerDeriverInterface {

  /**
   * Constructs a BlockContent object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The custom security provider storage.
   */
  public function __construct(protected ConfigFactoryInterface $configFactory) {
  }

  /**
   * {@inheritDoc}
   */
  #[\Override]
  public static function create(ContainerInterface $container, $base_plugin_id): self {
    return new static(
      $container->get('config.factory'),
    );
  }

  /**
   * {@inheritDoc}
   */
  #[\Override]
  public function getDerivativeDefinitions($base_plugin_definition): array {
    // Reset the discovered definitions.
    $this->derivatives = [];

    foreach ($this->configFactory->listAll('coveo_secured_search.custom_security_provider.') as $coveo_search) {
      $config = $this->configFactory->get($coveo_search);
      $this->derivatives[$config->get('name')] = $base_plugin_definition;
      $this->derivatives[$config->get('name')]['title'] = $config->get('label');
      $this->derivatives[$config->get('name')]['description'] = $config->get('description') ?? $base_plugin_definition['description'];
      $this->derivatives[$config->get('name')]['config_dependencies']['config'] = [$config->getName()];
    }

    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

}
