<?php

namespace Drupal\Tests\coveo_secured_search\Unit\Plugin\Coveo\CustomSecurityProvider;

use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Session\UserSession;
use Drupal\coveo_secured_search\Plugin\Coveo\CustomSecurityProvider\DrupalProvider;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * @coversDefaultClass \Drupal\coveo_secured_search\Plugin\Coveo\CustomSecurityProvider\DrupalProvider
 */
class DrupalProviderTest extends UnitTestCase {

  /**
   * @covers ::getNameFromId
   * @covers ::getName
   */
  public function testIdGeneration() {
    $sot = new DrupalProvider(
      [],
      'custom',
      [],
      $this->prophesize(LoggerChannelFactoryInterface::class)->reveal(),
      $this->prophesize(EventDispatcherInterface::class)->reveal(),
    );
    $account = new UserSession(['uid' => 1]);
    $params = $sot->generateParameters($account);
    $this->assertSame(
      $sot->getNameFromId('entity:user/1:en'),
      $params->getUserIds()[0]->getName(),
    );
  }

}
