<?php

declare(strict_types=1);

namespace Drupal\coveo\API;

use GuzzleHttp\ClientInterface;
use Neclimdul\OpenapiPhp\Helper\Configuration;

/**
 * Helper class to make API factories easier.
 */
class ApiFactory {

  public function __construct(private readonly ClientInterface $client) {}

  /**
   * Create a service.
   *
   * @param class-string<T> $class
   *   A Coveo API service class.
   * @param \Neclimdul\OpenapiPhp\Helper\Configuration $config
   *   API configuration.
   *
   * @return T
   *   The instantiated API service.
   *
   * @template T
   */
  public function create(string $class, Configuration $config) {
    return new $class($this->client, $config);
  }

}
