<?php

declare(strict_types=1);

namespace Drupal\coveo\API\Model;

use NecLimDul\Coveo\PushApi\Model\ModelInterface;
use NecLimDul\Coveo\PushApi\ObjectSerializer;
use Neclimdul\OpenapiPhp\Helper\Model\AdditionalPropertiesTrait;
use Neclimdul\OpenapiPhp\Helper\Model\ArrayAccessTrait;
use Neclimdul\OpenapiPhp\Helper\Model\ModelBase;

/**
 * Batch document body.
 *
 * @see https://docs.coveo.com/en/75/index-content/item-models#documentbody
 * @see https://docs.coveo.com/en/75/index-content/item-models#batchdocumentbody
 * @use \Neclimdul\OpenapiPhp\Helper\Model\ArrayAccessTrait<string, ?mixed>
 */
class BatchDocumentBody extends ModelBase implements ModelInterface, \ArrayAccess, \JsonSerializable {
  use AdditionalPropertiesTrait;

  use ArrayAccessTrait;

  /**
   * The original name of the model.
   *
   * @var string
   */
  protected static $openAPIModelName = 'BatchDocumentBody';

  /**
   * Array of property to type mappings. Used for (de)serialization.
   *
   * @var string[]
   * @phpstan-var array<string, string|class-string>
   * @psalm-var array<string, string|class-string>
   */
  protected static $openAPITypes = [
    'add_or_update' => '\Drupal\coveo\DocumentBody[]',
    'delete' => '\Drupal\coveo\Coveo\DeletedItem[]',
  ];

  /**
   * Array of property to format mappings. Used for (de)serialization.
   *
   * @var string[]
   * @phpstan-var array<string, string|null>
   * @psalm-var array<string, string|null>
   */
  protected static $openAPIFormats = [
    'add_or_update' => NULL,
    'delete' => NULL,
  ];

  /**
   * Array of attributes. Original name keyed by the local name.
   *
   * @var string[]
   */
  protected static $attributeMap = [
    'add_or_update' => 'addOrUpdate',
    'delete' => 'delete',
  ];

  /**
   * Array of attributes to setter functions (for deserialization of responses)
   *
   * @var string[]
   */
  protected static $setters = [
    'add_or_update' => 'setAddOrUpdate',
    'delete' => 'setDelete',
  ];

  /**
   * Array of attributes to getter functions (for serialization of requests)
   *
   * @var string[]
   */
  protected static $getters = [
    'add_or_update' => 'getAddOrUpdate',
    'delete' => 'getDelete',
  ];

  /**
   * Constructor.
   *
   * @param mixed[] $data
   *   Associated array of property values initializing the model.
   */
  public function __construct(array $data = []) {
    $this->container = $this->collectAttributeValues($data);
  }

  /**
   * {@inheritDoc}
   */
  public function valid(): bool {
    return count($this->listInvalidProperties()) === 0;
  }

  /**
   * {@inheritDoc}
   */
  public function listInvalidProperties(): array {
    return [];
  }

  /**
   * Gets add_or_update.
   *
   * @return \Drupal\coveo\DocumentBody[]|null
   *   List of add or update operations.
   */
  public function getAddOrUpdate(): ?array {
    return $this->container['add_or_update'];
  }

  /**
   * Sets add_or_update.
   *
   * @param \Drupal\coveo\DocumentBody[]|null $add_or_update
   *   List of add or update operations.
   *
   * @return self
   *   The current object.
   */
  public function setAddOrUpdate(?array $add_or_update): self {
    $this->container['add_or_update'] = $add_or_update;

    return $this;
  }

  /**
   * Gets delete.
   *
   * @return \Drupal\coveo\API\Model\DeletedItem[]|null
   *   List of delete operations.
   */
  public function getDelete(): ?array {
    return $this->container['delete'];
  }

  /**
   * Sets delete.
   *
   * @param \Drupal\coveo\API\Model\DeletedItem[]|null $delete
   *   List of delete operations.
   *
   * @return self
   *   The current object.
   */
  public function setDelete(?array $delete): self {
    $this->container['delete'] = $delete;

    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function jsonSerialize(): mixed {
    return ObjectSerializer::sanitizeForSerialization($this);
  }

}
