<?php

declare(strict_types=1);

namespace Drupal\coveo\API\Model;

use NecLimDul\Coveo\PushApi\Model\ModelInterface;
use NecLimDul\Coveo\PushApi\ObjectSerializer;
use Neclimdul\OpenapiPhp\Helper\Model\AdditionalPropertiesTrait;
use Neclimdul\OpenapiPhp\Helper\Model\ArrayAccessTrait;
use Neclimdul\OpenapiPhp\Helper\Model\ModelBase;

/**
 * Deleted Item class.
 *
 * @use \Neclimdul\OpenapiPhp\Helper\Model\ArrayAccessTrait<string, ?mixed>
 */
class DeletedItem extends ModelBase implements ModelInterface, \ArrayAccess, \JsonSerializable {
  use AdditionalPropertiesTrait;
  use ArrayAccessTrait;

  /**
   * The original name of the model.
   *
   * @var string
   */
  protected static $openAPIModelName = 'DeletedItem';

  /**
   * Array of property to type mappings. Used for (de)serialization.
   *
   * @var string[]
   * @phpstan-var array<string, string|class-string>
   * @psalm-var array<string, string|class-string>
   */
  protected static $openAPITypes = [
    'document_id' => 'string',
    'delete_children' => 'bool',
  ];

  /**
   * Array of property to format mappings. Used for (de)serialization.
   *
   * @var string[]
   * @phpstan-var array<string, string|null>
   * @psalm-var array<string, string|null>
   */
  protected static $openAPIFormats = [
    'document_id' => NULL,
    'delete_children' => NULL,
  ];

  /**
   * Array of attributes. Original name keyed by the local name.
   *
   * @var string[]
   */
  protected static $attributeMap = [
    'document_id' => 'documentId',
    'delete_children' => 'deleteChildren',
  ];

  /**
   * Array of attributes to setter functions (for deserialization of responses)
   *
   * @var string[]
   */
  protected static $setters = [
    'document_id' => 'setDocumentId',
    'delete_children' => 'setDeleteChildren',
  ];

  /**
   * Array of attributes to getter functions (for serialization of requests)
   *
   * @var string[]
   */
  protected static $getters = [
    'document_id' => 'getDocumentId',
    'delete_children' => 'getDeleteChildren',
  ];

  /**
   * Constructor.
   *
   * @param mixed[] $data
   *   Associated array of property values initializing the model.
   */
  public function __construct(array $data = []) {
    $this->container = $this->collectAttributeValues($data);
  }

  /**
   * {@inheritDoc}
   */
  public function valid(): bool {
    return count($this->listInvalidProperties()) === 0;
  }

  /**
   * {@inheritDoc}
   */
  public function listInvalidProperties(): array {
    return [];
  }

  /**
   * Gets document_id.
   *
   * @return string|null
   *   ID of the document to delete.
   */
  public function getDocumentId(): ?string {
    return $this->container['document_id'];
  }

  /**
   * Sets document_id.
   *
   * @param string|null $document_id
   *   ID of the document to delete.
   *
   * @return self
   *   Current item.
   */
  public function setDocumentId(?string $document_id): self {
    $this->container['document_id'] = $document_id;

    return $this;
  }

  /**
   * Gets delete_children.
   *
   * @return bool|null
   *   Delete children.
   */
  public function getDeleteChildren(): ?bool {
    return $this->container['delete_children'];
  }

  /**
   * Sets delete_children.
   *
   * @param bool|null $delete_children
   *   Delete children.
   *
   * @return self
   *   Current item.
   */
  public function setDeleteChildren(?bool $delete_children): self {
    $this->container['delete_children'] = $delete_children;

    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function jsonSerialize(): mixed {
    return ObjectSerializer::sanitizeForSerialization($this);
  }

}
