<?php

declare(strict_types=1);

namespace Drupal\coveo\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Declare a Coveo security provider plugin.
 *
 * @Annotation
 */
class CoveoSecurityProvider extends Plugin {

  /**
   * The plugin ID.
   */
  public string $id;

  /**
   * The human-readable title of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $title;

  /**
   * The description of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $description;

  /**
   * The plugin category. Should be built-in or custom.
   */
  public string $category = 'built-in';

  /**
   * The deriver class. Optional.
   */
  public ?string $deriver = NULL;

}
