<?php

declare(strict_types=1);

namespace Drupal\coveo\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeInterface;
use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Declare a Coveo token generator plugin.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class CoveoSecurityProvider extends Plugin implements AttributeInterface {

  /**
   * Construct a Coveo token generator plugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $title
   *   The human-readable title of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description of the plugin.
   * @param string $category
   *   The plugin category. Should be built-in or custom.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    string $id,
    public readonly ?TranslatableMarkup $title = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly string $category = 'built-in',
    ?string $deriver = NULL,
  ) {
    parent::__construct($id, $deriver);
  }

}
