<?php

declare(strict_types=1);

namespace Drupal\coveo\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\coveo\Plugin\CoveoSecurityProviderManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Security provider overview controller.
 *
 * Provides a basic overview of available security providers.
 */
class SecurityProviders extends ControllerBase {

  /**
   * Constructs a new EntityListBuilder object.
   *
   * @param \Drupal\coveo\Plugin\CoveoSecurityProviderManagerInterface $securityProviderManager
   *   Security provider plugin manager.
   */
  public function __construct(
    private CoveoSecurityProviderManagerInterface $securityProviderManager,
  ) {}

  /**
   * {@inheritDoc}
   */
  #[\Override]
  public static function create(ContainerInterface $container): static {
    return new static(
      $container->get('plugin.manager.coveo_security_provider'),
    );
  }

  /**
   * Coveo security provider overview controller callback.
   */
  public function overview() {
    $build = [];

    $build['security_providers'] = [
      '#weight' => -1,
      'heading' => [
        '#type' => 'html_tag',
        '#tag' => 'h3',
        '#value' => 'Available security providers',
      ],
      'table' => [
        '#type' => 'table',
        '#header' => [
          $this->t('Provider'),
          $this->t('Description'),
          $this->t('Category'),
        ],
        '#rows' => [],
      ],
    ];

    foreach (
      $this->securityProviderManager->getSortedDefinitions(
      ) as $id => $definition
    ) {
      $build['security_providers']['table']['#rows'][$id] = [
        $definition['title'],
        $definition['description'] ?? '',
        $definition['category'],
      ];
    }

    return $build;
  }

}
