<?php

declare(strict_types=1);

namespace Drupal\coveo\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Session\AccountInterface;
use Drupal\coveo\Entity\CoveoSearchComponentInterface;
use NecLimDul\Coveo\SearchApi\Model\RestTokenParams;

/**
 * Event to allow the altering of a search token during generation.
 */
class CoveoTokenAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \NecLimDul\Coveo\SearchApi\Model\RestTokenParams $tokenParameters
   *   Token generation parameters.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The account being used to create the token.
   * @param \Drupal\coveo\Entity\CoveoSearchComponentInterface $search
   *   Search component generating a token.
   */
  public function __construct(
    public RestTokenParams $tokenParameters,
    public readonly AccountInterface $account,
    public readonly CoveoSearchComponentInterface $search,
  ) {}

}
