<?php

declare(strict_types=1);

namespace Drupal\coveo\Plugin\Coveo\SecurityProvider;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\coveo\Attribute\CoveoSecurityProvider;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\coveo\Entity\CoveoSearchComponent;
use Drupal\coveo\Plugin\CoveoSecurityProviderPluginInterface;

/**
 * Simple Token pass-through provider.
 */
#[CoveoSecurityProvider(
  id: 'token_provider',
  title: new TranslatableMarkup('Token Provider'),
  description: new TranslatableMarkup("Trivial implementation that passes through the provided token. Not a best practice, use with care."),
)]
class TokenProvider extends PluginBase implements CoveoSecurityProviderPluginInterface {

  /**
   * {@inheritDoc}
   */
  #[\Override]
  public function generateToken(CoveoSearchComponent $search, AccountInterface $account): string {
    return $search->searchKey();
  }

  /**
   * {@inheritDoc}
   */
  #[\Override]
  public function getIdentityProviderId(): string {
    // @todo this probably means we need a better interface for this method.
    throw new \Exception('Not implemented');
  }

}
