<?php

declare(strict_types=1);

namespace Drupal\coveo\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\coveo\Entity\CoveoSearchComponent;

/**
 * Provides an interface for Coveo security provider plugins.
 */
interface CoveoSecurityProviderPluginInterface extends PluginInspectionInterface {

  /**
   * Generate a token for a user.
   *
   * @param \Drupal\coveo\Entity\CoveoSearchComponent $search
   *   Related Coveo search definition.
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user to generate a token for. Generally the current user.
   *
   * @return string
   *   Search token.
   */
  public function generateToken(CoveoSearchComponent $search, AccountInterface $account): string;

  /**
   * Get the Coveo internal provider ID for this plugin.
   *
   * @return string
   *   The internal provider id.
   */
  public function getIdentityProviderId(): string;

}
