<?php

declare(strict_types=1);

namespace Drupal\coveo;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;
use Drupal\coveo\Entity\CoveoSearchComponentInterface;

/**
 * Defines a class to build a listing of Coveo search entities.
 *
 * @see \Drupal\coveo\Entity\CoveoSearchComponent
 */
class SearchComponentListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Style name');
    $header['organization'] = $this->t('Organization');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    assert($entity instanceof CoveoSearchComponentInterface);
    $row['label'] = $entity->label();
    $row['organization'] = $entity->getOrganization()->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();
    $build['table']['#empty'] = $this->t('There are currently no Coveo search components defined. <a href=":url">Add a new one</a>.', [
      ':url' => Url::fromRoute('coveo.coveo_search_component_add')->toString(),
    ]);
    return $build;
  }

}
