<?php

namespace Drupal\Tests\coveo\Kernel;

use Drupal\Component\Serialization\Yaml;
use Drupal\KernelTests\KernelTestBase;

/**
 * Provide a way of smoke testing service definitions.
 */
abstract class ServiceTestBase extends KernelTestBase {

  /**
   * Provide list of services for definition test.
   */
  abstract public static function providerServiceDefinitions(): \Generator;

  /**
   * Generate a list of service definition arguments for the service test.
   *
   * @param string $service_file
   *   Service file containing definitions.
   */
  public static function generateServiceData(string $service_file): \Generator {
    $services = Yaml::decode(file_get_contents($service_file));
    foreach ($services['services'] as $service_name => $service_definition) {
      if (isset($service_definition['parent'])) {
        // @todo Figure out a way to test these.
        continue;
      }
      yield $service_name => [
        $service_name,
        $service_definition['class'] ?? $service_name,
      ];
    }
  }

  /**
   * Basic smoke test for service file definitions.
   *
   * @dataProvider providerServiceDefinitions
   */
  public function testServices(string $service_name, string $class): void {
    // @phpstan-ignore method.impossibleType
    $this->assertInstanceOf($class, $this->container->get($service_name));
  }

}
