<?php

namespace Drupal\Tests\coveo\Unit\API;

use Drupal\coveo\API\FieldApiFactory;
use GuzzleHttp\Client;
use NecLimDul\Coveo\FieldApi\Api\FieldsApi;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\coveo\API\FieldApiFactory
 */
class FieldApiFactoryTest extends TestCase {

  /**
   * @covers ::create
   */
  public function testCreate(): void {
    $client = new Client();
    $sot = new FieldApiFactory($client);
    $service = $sot->create(FieldsApi::class, 'test123');
    $this->assertInstanceOf(FieldsApi::class, $service);
    $this->assertSame('test123', $service->getConfig()->getAccessToken());
  }

}
