<?php

namespace Drupal\Tests\coveo\Unit\API;

use Drupal\coveo\API\SearchApiFactory;
use GuzzleHttp\Client;
use NecLimDul\Coveo\SearchApi\Api\SearchV2Api;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\coveo\API\SearchApiFactory
 */
class SearchApiFactoryTest extends TestCase {

  /**
   * @covers ::create
   */
  public function testCreate(): void {
    $client = new Client();
    $sot = new SearchApiFactory($client);
    $service = $sot->create(SearchV2Api::class, 'test123');
    $this->assertInstanceOf(SearchV2Api::class, $service);
    $this->assertSame('test123', $service->getConfig()->getAccessToken());
  }

}
