<?php

namespace Drupal\credential_mask\EventSubscriber;

use Drupal\credential_mask\SensitiveConfigManager;
use Drupal\Core\Config\ConfigEvents as CoreConfigEvents;
use Drupal\Core\Config\StorageTransformEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribe to configuration import and export events.
 */
class ConfigEvents implements EventSubscriberInterface {

  /**
   * Sensitive configuration manager.
   *
   * @var \Drupal\credential_mask\SensitiveConfigManager
   */
  protected $sensitiveConfigManager;

  /**
   * ConfigFilterEventSubscriber constructor.
   *
   * @param \Drupal\credential_mask\SensitiveConfigManager $sensitive_config_manager
   *   The sensitive config manager service.
   */
  public function __construct(SensitiveConfigManager $sensitive_config_manager) {
    $this->sensitiveConfigManager = $sensitive_config_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events[CoreConfigEvents::STORAGE_TRANSFORM_IMPORT][] = ['onImportTransform'];
    $events[CoreConfigEvents::STORAGE_TRANSFORM_EXPORT][] = ['onExportTransform'];
    return $events;
  }

  /**
   * The storage is transformed for importing.
   *
   * @param \Drupal\Core\Config\StorageTransformEvent $event
   *   The event for altering configuration of the storage.
   */
  public function onImportTransform(StorageTransformEvent $event) {
    $storage = $event->getStorage();
    $this->sensitiveConfigManager->unmask($storage);
  }

  /**
   * The storage is transformed for exporting.
   *
   * @param \Drupal\Core\Config\StorageTransformEvent $event
   *   The event for altering configuration of the storage.
   */
  public function onExportTransform(StorageTransformEvent $event) {
    $storage = $event->getStorage();
    $this->sensitiveConfigManager->mask($storage);
  }

}
