Cricket Chatbot
INTRODUCTION

Cricket Chatbot provides a user-friendly chatbot interface for cricket enthusiasts to get information about matches, players, and cricket series. Users can ask questions in natural language about current match scores, upcoming fixtures, player statistics, and more.
REQUIREMENTS

This module requires no modules outside of Drupal core.
INSTALLATION

    Install as you would normally install a contributed Drupal module. Visit https://www.drupal.org/node/1897420 for further information.

CONFIGURATION

    Navigate to Administration > Configuration > Web Services > Cricket Chatbot Settings (/admin/config/services/cricket-chatbot)
    Configure the API provider and settings:
        Select which cricket data API to use (Cricket Data.org, API-Cricket, or API-Sports)
        Enter your API key (or use "DEMO-MODE" for testing with mock data)
        Set the cache time for API responses
        Customize the welcome message shown to users
    Place the Cricket Chatbot block in your desired region through Structure > Block layout.
    Configure the block settings:
        Adjust the chatbot title
        Set the chatbot height in pixels

USAGE

Users can interact with the chatbot by typing questions such as:

    "What's the score in the India match?"
    "When is the next Australia game?"
    "Who won the England match yesterday?"
    "Tell me about Virat Kohli's stats"
    "Show me information about the IPL"

The chatbot interprets these natural language queries and provides relevant cricket information.
FEATURES

    Natural language query processing
    Information about current matches, scores, and status
    Upcoming match schedules
    Recent match results
    Player statistics and information
    Series/tournament details
    Responsive design that works across devices
    Caching system to minimize API usage

TROUBLESHOOTING

    If the chatbot doesn't respond correctly, check that your API key is valid or try using "DEMO-MODE"
    If styles don't apply correctly, clear the Drupal cache
    If the chatbot block doesn't appear, ensure you've placed it in a region and cleared caches

FAQ

Q: Do I need an API key to use this module?

A: You can use the module in "DEMO-MODE" without an API key, but it will only show mock data. For live cricket data, you'll need an API key from one of the supported providers.

Q: How can I customize the appearance of the chatbot?

A: You can override the CSS classes in your theme. The main classes are .cricket-chatbot, .cricket-chatbot__messages, .cricket-chatbot__message, etc.
MAINTAINERS

Current maintainers:

    [Saurabh Kanva] - https://www.drupal.org/u/saurabhkanva
