# Releasing cricket_chatbot for Drupal 11

This module has been updated to support Drupal 10 and Drupal 11.

## What changed
- `cricket_chatbot.info.yml` updated to `core_version_requirement: ^10 || ^11`.
- `composer.json` added to support Composer-based installs and to declare PHP/drupal/core requirements.

## How to test locally
1. Use a Drupal 11 site (PHP 8.2+) or a local Lando/DDEV site running Drupal 11.
2. Place the module in `modules/contrib/cricket_chatbot` (or install via Composer if published).
3. Enable the module: `drush en cricket_chatbot -y`.
4. Visit the configuration page: `/admin/config/services/cricket-chatbot` and verify settings and chatbot behavior.
5. Run `drush cr` and test routes and block: place the Chatbot block on a region.

## How to release on Drupal.org
1. Create a project on Drupal.org (if not already).
2. Push code to a Git repository and follow Drupal.org packaging guidelines (create proper branches: 1.x-1.0, 1.x-1.x-dev).
3. Tag a release (e.g., `1.0.0`) in the git repository.
4. Use Drupal.org's packaging to generate a release tarball, or enable Git-based releases.

## How to publish via Composer (Packagist/GitHub)
1. Push to GitHub and tag a release.
2. Register the GitHub repository on Packagist (or enable GitHub integration in Composer).
3. Users can then `composer require drupal/cricket_chatbot`.

## Notes and follow-ups
- If your module uses any APIs deprecated in Drupal 11, update them. I scanned the code for obvious issues and updated the info and composer files. If you want, I can run an automated deprecation check and patch each deprecated API usage.
