(function ($, Drupal, drupalSettings) {

  'use strict';

  Drupal.behaviors.cricketChatbot = {
    attach: function (context, settings) {
      // Iterate through all chatbot instances on the page
      $.each(drupalSettings.cricketChatbot || {}, function (chatbotId, config) {
        // Select the chatbot container
        var $chatbot = $('#' + chatbotId, context);
        
        // Only initialize once by checking for a data attribute
        if (!$chatbot.data('cricket-chatbot-initialized')) {
          $chatbot.data('cricket-chatbot-initialized', true);
          initChatbot($chatbot, config);
        }
      });
    }
  };

  function initChatbot($chatbot, config) {
    var $messages = $chatbot.find('.cricket-chatbot__messages');
    var $input = $chatbot.find('.cricket-chatbot__input');
    var $send = $chatbot.find('.cricket-chatbot__send');
    
    // Set height based on configuration
    $messages.css('height', config.height + 'px');
    
    // Send message function
    function sendMessage() {
      var message = $input.val().trim();
      
      if (message === '') {
        return;
      }
      
      addMessage(message, 'user');
      
      // Clear input
      $input.val('');
      
      showTypingIndicator();
      
      // Send message to backend
      $.ajax({
        url: Drupal.url('api/cricket-chatbot/chat'),
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({
          query: message
        }),
        success: function (response) {
          removeTypingIndicator();
          
          if (response.status === 'success') {
            addMessage(response.response, 'bot');
          }
          else {
            addMessage('Sorry, I encountered an error. Please try again later.', 'bot');
          }
        },
        error: function () {
          removeTypingIndicator();
          addMessage('Sorry, I encountered an error. Please try again later.', 'bot');
        }
      });
    }
    
    function addMessage(message, type) {
      var $message = $('<div class="cricket-chatbot__message cricket-chatbot__message--' + type + '"></div>');
      $message.text(message);
      $messages.append($message);
      
      $messages.scrollTop($messages[0].scrollHeight);
    }
    
    function showTypingIndicator() {
      var $typing = $('<div class="cricket-chatbot__message cricket-chatbot__message--bot cricket-chatbot__typing"></div>');
      $typing.text('...');
      $messages.append($typing);
      
      $messages.scrollTop($messages[0].scrollHeight);
    }
    function removeTypingIndicator() {
      $chatbot.find('.cricket-chatbot__typing').remove();
    }
    
    $send.on('click', function(e) {
      sendMessage();
      return false;
    });
    
    $input.on('keypress', function (e) {
      if (e.which === 13) {
        sendMessage();
        return false;
      }
    });
  }

})(jQuery, Drupal, drupalSettings);