<?php

declare(strict_types=1);

namespace Drupal\critical_css_ui\Asset;

/**
 * Defines an interface for a Critical CSS Provider.
 *
 * Classes implementing this interface calculate which CSS must be used for
 * Critical CSS from entities and return its contents.
 */
interface CriticalCssProviderInterface {

  /**
   * Get critical CSS contents.
   *
   * @return string
   *   The critical CSS contents.
   */
  public function getCriticalCss(): string;

  /**
   * Check if module is enabled.
   *
   * @return bool
   *   True if this module is enabled.
   */
  public function isEnabled(): bool;

  /**
   * Tells whether this request has been already processed.
   *
   * @return bool
   *   True if already processed, false otherwise.
   */
  public function isAlreadyProcessed(): bool;

  /**
   * Reset provider so calculations are made again.
   */
  public function reset(): void;

}

