<?php

declare(strict_types=1);

namespace Drupal\critical_css_ui\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Critical CSS UI settings.
 */
final class CriticalCssConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['critical_css_ui.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'critical_css_ui_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('critical_css_ui.settings');

    $form['enabled'] = [
      '#type'          => 'checkbox',
      '#title'         => $this->t('Enable Critical CSS'),
      '#description'   => $this->t('When enabled, Critical CSS will be injected into pages based on the configured target contexts.'),
      '#default_value' => $config->get('enabled'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('critical_css_ui.settings')
      ->set('enabled', (bool) $form_state->getValue('enabled'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}

