<?php

declare(strict_types=1);

namespace Drupal\critical_css_ui\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines dynamic local tasks for Critical CSS.
 */
class CriticalCssLocalTasks extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * Constructs a new CriticalCssLocalTasks.
   *
   * @param \Drupal\Core\StringTranslation\TranslationInterface $string_translation
   *   The translation manager.
   */
  public function __construct(TranslationInterface $string_translation) {
    $this->stringTranslation = $string_translation;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('string_translation')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    $this->derivatives = [];

    // Add tab for node canonical route.
    $this->derivatives['node.critical_css'] = [
      'route_name' => 'entity.critical_css.node_form',
      'title' => $this->t('Critical CSS'),
      'base_route' => 'entity.node.canonical',
      'weight' => 100,
    ];

    // Add tab for node type routes.
    $this->derivatives['entity.node_type.critical_css'] = [
      'route_name' => 'entity.critical_css.node_type_form',
      'title' => $this->t('Critical CSS'),
      'base_route' => 'entity.node_type.edit_form',
      'weight' => 100,
    ];

    return $this->derivatives;
  }

}
