# Critical CSS UI

A Drupal module that provides a UI to manage Critical CSS entities stored in the database, allowing you to inject critical CSS into pages based on target contexts (node IDs, node bundles, etc.).

## Description

This module extends the functionality of the [Critical CSS](https://www.drupal.org/project/critical_css) module by providing a user interface to manage Critical CSS entries stored as entities in the database, rather than requiring CSS files in the theme directory.

## Why Critical CSS UI?

In modern Drupal sites, initial performance is often affected by excessive CSS loading. Popular themes like Bootstrap and Bootstrap Barrio:

- Include entire component sets, even when not all are used
- Produce very large and heavy final CSS files
- Load this CSS on all pages without discrimination

### The Problem with Static CSS

For sites where editors can build custom landing pages using tools like Layout Builder or Paragraphs, each page can have:
- A unique structure
- Different blocks, sections, and components
- Different style requirements

This makes critical CSS:
- **Contextual**: Each page needs different critical CSS
- **Dynamic**: Cannot be versioned statically in the theme (as recommended by the `critical_css` module)
- **Flexible**: Requires dynamic, flexible, and page-specific management

### How Critical CSS UI Helps

Critical CSS UI allows you to:

- **Associate critical CSS fragments** to key site contexts:
  - `node:1`, `node:article` (initial phase)
- **Inject critical CSS** in the `<head>` only when accessing that specific context
- **Manage associations** from the user interface (tabs like "Edit" or "View") on nodes, content types, and other entities
- **Decouple CSS management** from the theme, giving more flexibility to frontend teams and editors

## Features

- **Entity-based Critical CSS**: Store Critical CSS in the database as entities
- **Context-based matching**: Automatically match Critical CSS based on:
  - Node ID (e.g., `node:123`)
  - Node bundle (e.g., `node:article`)
  - Default fallback
- **UI Integration**: Manage Critical CSS directly from:
  - Node edit pages (tab)
  - Node type configuration pages (tab)
  - Admin configuration page
- **Automatic CSS injection**: Inline critical CSS in the HTML head
- **Async CSS loading**: Automatically loads non-critical CSS asynchronously

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1+

## Installation

1. Install the module using Composer:
   ```bash
   composer require drupal/critical_css_ui
   ```

2. Enable the module:
   ```bash
   drush en critical_css_ui
   ```

   Or via the admin interface: `/admin/modules`

3. Configure the module at `/admin/config/development/performance/critical-css`

## Configuration

1. Navigate to **Configuration > Development > Performance > Critical CSS**
2. Enable the module by checking "Enable Critical CSS"
3. Save the configuration

## Usage

### Managing Critical CSS for a specific node

1. Navigate to any node edit page
2. Click on the "Critical CSS" tab
3. Enter your critical CSS in the textarea
4. Save

The target context will be automatically set to `node:{id}` (e.g., `node:123`)

### Managing Critical CSS for a node type

1. Navigate to **Structure > Content types > [Your content type]**
2. Click on the "Critical CSS" tab
3. Enter your critical CSS in the textarea
4. Save

The target context will be automatically set to `node:{bundle}` (e.g., `node:article`)

### Managing Critical CSS manually

1. Navigate to **Configuration > Development > Performance > Critical CSS > List**
2. Click "Add Critical CSS"
3. Enter:
   - **Target Context**: The context to match (e.g., `node:123`, `node:article`, `default`)
   - **CSS**: Your critical CSS content
   - **Status**: Enable/disable this entry
4. Save

## How it works

The module decorates Drupal's CSS collection renderer service and:

1. Checks if Critical CSS is enabled
2. Determines the current page context (node ID, bundle, etc.)
3. Searches for matching Critical CSS entities in this order:
   - `node:{id}` (most specific)
   - `node:{bundle}` (less specific)
   - `default` (fallback)
4. Injects the matching CSS inline in the HTML `<head>`
5. Loads remaining CSS files asynchronously

## Context matching

The module automatically creates target contexts based on the current page:

- **For node pages**: `node:123` (where 123 is the node ID)
- **For node bundles**: `node:article` (where article is the bundle name)
- **Default fallback**: `default`

## Troubleshooting

### Critical CSS not appearing

1. Check that the module is enabled in the configuration
2. Verify that you have a Critical CSS entity with matching target context
3. Ensure the entity status is enabled
4. Clear Drupal cache: `drush cr`
5. Check that you're not on an admin route (Critical CSS is disabled for admin routes)

### Conflict with critical_css module

If you have the `critical_css` contrib module enabled, you should disable it as both modules decorate the same service. Only one decorator can be active at a time.

## Development

### Project structure

```
critical_css_ui/
├── config/              # Configuration files
├── src/
│   ├── Asset/          # CSS renderer and provider
│   ├── Entity/         # Critical CSS entity definition
│   ├── Form/           # Form controllers
│   └── Plugin/         # Plugin derivatives
└── critical_css_ui.info.yml
```

## License

GPL-2.0-or-later

## Maintainers

- Diego Duran

## Support

For bug reports and feature requests, please use the [issue queue](https://www.drupal.org/project/issues/critical_css_ui).

