(function ($, Drupal, once) {

  Drupal.behaviors.changeSubmitButtonTitle = {
    attach: function (context, settings) {
      // Use once with jQuery selectors and attach behavior using the context
      $(once('changeSubmitButtonTitle', 'input[data-drupal-selector="edit-nicey-template-finalise-review"]', context)).each(function () {
        const checkbox = this;
        const submitButton = $(once('changeChildButtonTitle', 'input[data-drupal-selector="edit-submit"]', context)).get(0);

        if (checkbox && submitButton) {
          $(checkbox).on('click', function () {
            if (checkbox.checked) {
              submitButton.value = 'Finalise Review';
            } else {
              submitButton.value = 'Save Draft';
            }
          });
        }
      });
    }
  };
})(jQuery, Drupal, once);
