/**
 * @file
 * JavaScript behaviors for the relationship type form.
 */

(function ($, Drupal) {
  /**
   * Provide summary for the relationship limits vertical tab.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.crmRelationshipTypeLimitsSummary = {
    attach(context) {
      $(context)
        .find('[data-drupal-selector="edit-limits"]')
        .drupalSetSummary(function (context) {
          const summary = [];
          const limitAElement = context.querySelector(
            '[data-drupal-selector="edit-limit-a"]',
          );
          const limitBElement = context.querySelector(
            '[data-drupal-selector="edit-limit-b"]',
          );
          const activeOnlyElement = context.querySelector(
            '[data-drupal-selector="edit-limit-active-only"]',
          );
          const limitA = limitAElement ? limitAElement.value : '';
          const limitB = limitBElement ? limitBElement.value : '';
          const activeOnly = activeOnlyElement
            ? activeOnlyElement.checked
            : false;

          if (limitA) {
            summary.push(Drupal.t('Contact A: @limit', { '@limit': limitA }));
          }
          if (limitB) {
            summary.push(Drupal.t('Contact B: @limit', { '@limit': limitB }));
          }
          if (activeOnly) {
            summary.push(Drupal.t('Active only'));
          }

          return summary.length ? summary.join(', ') : Drupal.t('No limits');
        });
    },
  };

  /**
   * Provide summary for the valid contacts vertical tab.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.crmRelationshipTypeValidContactsSummary = {
    attach(context) {
      $(context)
        .find('[data-drupal-selector="edit-valid-contacts"]')
        .drupalSetSummary(function (context) {
          const summary = [];
          const contactsAElement = context.querySelector(
            '[data-drupal-selector="edit-valid-contacts-a"]',
          );
          const contactsBElement = context.querySelector(
            '[data-drupal-selector="edit-valid-contacts-b"]',
          );
          const contactsA = contactsAElement ? contactsAElement.value : '';
          const contactsB = contactsBElement ? contactsBElement.value : '';

          // Count contacts by splitting on comma (entity autocomplete format).
          if (contactsA && contactsA.trim()) {
            const countA = contactsA.split(',').filter(function (s) {
              return s.trim();
            }).length;
            summary.push(
              Drupal.formatPlural(
                countA,
                'Contact A: 1 contact',
                'Contact A: @count contacts',
              ),
            );
          }
          if (contactsB && contactsB.trim()) {
            const countB = contactsB.split(',').filter(function (s) {
              return s.trim();
            }).length;
            summary.push(
              Drupal.formatPlural(
                countB,
                'Contact B: 1 contact',
                'Contact B: @count contacts',
              ),
            );
          }

          return summary.length
            ? summary.join(', ')
            : Drupal.t('No restrictions');
        });
    },
  };

  /**
   * Provide summary for the contact readonly vertical tab.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.crmRelationshipTypeContactReadonlySummary = {
    attach(context) {
      $(context)
        .find('[data-drupal-selector="edit-contact-readonly"]')
        .drupalSetSummary(function (context) {
          const summary = [];
          const readonlyAElement = context.querySelector(
            '[data-drupal-selector="edit-readonly-contact-a"]',
          );
          const readonlyBElement = context.querySelector(
            '[data-drupal-selector="edit-readonly-contact-b"]',
          );
          const readonlyA = readonlyAElement ? readonlyAElement.checked : false;
          const readonlyB = readonlyBElement ? readonlyBElement.checked : false;

          if (readonlyA && readonlyB) {
            summary.push(Drupal.t('Both read-only'));
          } else if (readonlyA) {
            summary.push(Drupal.t('Contact A read-only'));
          } else if (readonlyB) {
            summary.push(Drupal.t('Contact B read-only'));
          }

          return summary.length
            ? summary.join(', ')
            : Drupal.t('Contacts editable');
        });
    },
  };
})(jQuery, Drupal);
