<?php

namespace Drupal\crm;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the contact detail entity type.
 */
class ContactDetailAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {

    if ($account->hasPermission('administer crm')) {
      return AccessResult::allowed();
    }

    /** @var \Drupal\crm\CrmContactDetailInterface $entity */
    $contact = $entity->get('crm_contact')?->entity;
    // If no parent contact is found, deny access.
    if (!$contact) {
      return AccessResult::forbidden('Contact detail must have a parent contact.');
    }

    switch ($operation) {
      case 'view':
        return $contact->access($operation, $account, TRUE);

      case 'update':
        return $contact->access($operation, $account, TRUE);

      case 'delete':
        return $contact->access('update', $account, TRUE);
    }

    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    $permissions = [
      'create crm_contact',
      'edit any crm_contact',
      'administer crm',
    ];

    return AccessResult::allowedIfHasPermissions($account, $permissions, 'OR');
  }

}
