<?php

declare(strict_types=1);

namespace Drupal\crm;

use Drupal\views\EntityViewsData;

/**
 * Provides Views data for the CRM Contact entity.
 */
class ContactViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData(): array {
    $data = parent::getViewsData();

    if (isset($data['crm_contact__relationship_statistics'])) {
      $data['crm_contact__relationship_statistics']['relationship_statistics_value']['title'] = $this->t('Relationship Type');
      $data['crm_contact__relationship_statistics']['relationship_statistics_value']['help'] = $this->t('The relationship type key.');
      $data['crm_contact__relationship_statistics']['relationship_statistics_value']['filter'] = [
        'id' => 'crm_relationship_statistics_type',
      ];

      $data['crm_contact__relationship_statistics']['relationship_statistics_count']['title'] = $this->t('Relationship Count');
      $data['crm_contact__relationship_statistics']['relationship_statistics_count']['help'] = $this->t('The number of relationships of this type.');
      $data['crm_contact__relationship_statistics']['relationship_statistics_count']['field'] = [
        'id' => 'crm_relationship_statistics',
      ];
      $data['crm_contact__relationship_statistics']['relationship_statistics_count']['sort'] = [
        'id' => 'crm_relationship_statistics_count',
      ];
    }

    return $data;
  }

}
