<?php

declare(strict_types=1);

namespace Drupal\crm;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;

/**
 * Interface for CRM contact type entities.
 */
interface CrmRelationshipTypeInterface extends ConfigEntityInterface, EntityDescriptionInterface {

  /**
   * Determines whether the relationship type is locked.
   *
   * @return string|false
   *   The module name that locks the type or FALSE.
   */
  public function isLocked();

  /**
   * Gets the description.
   *
   * @return string
   *   The description of this relationship type.
   */
  public function getDescription();

  /**
   * Gets the maximum number of relationships for Contact A position.
   *
   * @return int|null
   *   The maximum limit, or NULL if unlimited.
   */
  public function getLimitA(): ?int;

  /**
   * Gets the maximum number of relationships for Contact B position.
   *
   * @return int|null
   *   The maximum limit, or NULL if unlimited.
   */
  public function getLimitB(): ?int;

  /**
   * Determines whether limits only count active relationships.
   *
   * @return bool
   *   TRUE if only active relationships count toward the limit.
   */
  public function isLimitActiveOnly(): bool;

  /**
   * Gets the valid contact IDs for Contact A position.
   *
   * @return array
   *   An array of contact entity IDs, or empty array if no restrictions.
   */
  public function getValidContactsA(): array;

  /**
   * Gets the valid contact IDs for Contact B position.
   *
   * @return array
   *   An array of contact entity IDs, or empty array if no restrictions.
   */
  public function getValidContactsB(): array;

  /**
   * Determines whether Contact A is read-only after being set.
   *
   * @return bool
   *   TRUE if Contact A cannot be changed after being set.
   */
  public function isReadonlyContactA(): bool;

  /**
   * Determines whether Contact B is read-only after being set.
   *
   * @return bool
   *   TRUE if Contact B cannot be changed after being set.
   */
  public function isReadonlyContactB(): bool;

}
