<?php

namespace Drupal\crm;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\user\UserInterface;

/**
 * Provides an interface defining a user contact mapping entity type.
 */
interface CrmUserContactMappingInterface extends ContentEntityInterface {

  /**
   * Returns the relation user entity.
   *
   * @return \Drupal\user\UserInterface
   *   The relation user entity.
   */
  public function getUser();

  /**
   * Sets the relation user entity.
   *
   * @param \Drupal\user\UserInterface $account
   *   The relation user entity.
   *
   * @return $this
   */
  public function setUser(UserInterface $account);

  /**
   * Returns the relation user ID.
   *
   * @return int|null
   *   The relation user ID, or NULL in case the user ID field has not been set.
   */
  public function getUserId();

  /**
   * Sets the relation user ID.
   *
   * @param int $uid
   *   The relation user id.
   *
   * @return $this
   */
  public function setUserId($uid);

  /**
   * Returns the relation person entity.
   *
   * @return \Drupal\crm\CrmContactInterface
   *   The relation person entity.
   */
  public function getContact();

  /**
   * Sets the relation person entity.
   *
   * @param \Drupal\crm\CrmContactInterface $person
   *   The relation person entity.
   *
   * @return $this
   */
  public function setContact(CrmContactInterface $person);

  /**
   * Returns the relation person ID.
   *
   * @return int|null
   *   The relation person ID, or NULL in case the person ID field has not been
   *   set.
   */
  public function getContactId();

  /**
   * Sets the relation person ID.
   *
   * @param int $contact_id
   *   The relation person id.
   *
   * @return $this
   */
  public function setContactId($contact_id);

}
