<?php

namespace Drupal\crm;

use Drupal\user\UserInterface;

/**
 * CRM User Contact Mapping sync relation service.
 */
interface CrmUserContactMappingSyncRelationInterface {

  /**
   * Retrieves the person ID from the user ID.
   *
   * @return int|null
   *   Contact ID, if relation exists.
   */
  public function getContactIdFromUserId($user_id);

  /**
   * Retrieves the user ID from the person ID.
   *
   * @return int|null
   *   User ID, if relation exists.
   */
  public function getUserIdFromContactId($contact_id);

  /**
   * Retrieves the relation ID from the user ID.
   *
   * @return int|null
   *   Relation ID, if exists.
   */
  public function getRelationIdFromUserId($user_id);

  /**
   * Retrieves the relation ID from the person ID.
   *
   * @return int|null
   *   Relation ID, if exists.
   */
  public function getRelationIdFromContactId($contact_id);

  /**
   * Synchronizes user and contact.
   *
   * @param \Drupal\user\UserInterface $account
   *   Account to be synchronized. Programmatically created accounts can
   *   override default behavior by setting
   *   $account->crm_core_no_auto_sync = TRUE.
   * @param \Drupal\crm\CrmContactInterface $person
   *   Contact to be associated with $account.
   *
   * @return \Drupal\crm\ContactInterface
   *   A contact object.
   *
   * @throws \Drupal\Core\Entity\EntityStorageException
   */
  public function relate(UserInterface $account, ?CrmContactInterface $person = NULL);

}
