<?php

namespace Drupal\crm\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\crm\CrmUserContactMappingInterface;

/**
 * Event that is fired when a user is created, and auto create is enabled.
 */
class CrmUserContactMappingEvent extends Event {

  /**
   * The event name.
   *
   * @var string
   */
  const EVENT_NAME = 'crm_user_contact_mapping_event';


  /**
   * The crm user contact mapping.
   *
   * @var \Drupal\crm\CrmUserContactMappingInterface
   */
  protected $crmUserContactMapping;

  /**
   * Constructs a new CrmUserContactMappingEvent.
   *
   * @param \Drupal\crm\CrmUserContactMappingInterface $crm_user_contact_mapping
   *   The crm user contact mapping.
   */
  public function __construct(CrmUserContactMappingInterface $crm_user_contact_mapping) {
    $this->crmUserContactMapping = $crm_user_contact_mapping;
  }

  /**
   * Get the crm user contact mapping.
   *
   * @return \Drupal\crm\CrmUserContactMappingInterface
   *   The crm user contact mapping.
   */
  public function getCrmUserContactMapping(): CrmUserContactMappingInterface {
    return $this->crmUserContactMapping;
  }

  /**
   * Set the crm user contact mapping.
   *
   * @param \Drupal\crm\CrmUserContactMappingInterface $crm_user_contact_mapping
   *   The crm user contact mapping.
   */
  public function setCrmUserContactMapping(CrmUserContactMappingInterface $crm_user_contact_mapping): void {
    $this->crmUserContactMapping = $crm_user_contact_mapping;
  }

}
