<?php

namespace Drupal\crm\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * CRM User Contact Mapping settings form.
 */
class UserContactMappingSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'crm_user_contact_mapping_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'crm.user_contact_mapping.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $settings = $this->config('crm.user_contact_mapping.settings');
    $form['display_name'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Display name'),
      '#default_value' => $settings->get('display_name'),
      '#description' => $this->t('Override the User name with the CRM name.'),
    ];

    $form['create_event'] = [
      '#type' => 'details',
      '#title' => $this->t('Create event'),
      '#open' => TRUE,
    ];

    $form['create_event']['auto_create_crm_user_contact_mapping'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Create CRM user contact mapping automatically'),
      '#default_value' => $settings->get('auto_create_crm_user_contact_mapping'),
      '#description' => $this->t('Automatically create a contact mapping when a user is created.'),
    ];

    $form['create_event']['auto_create_lookup_contact'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Lookup contact automatically'),
      '#default_value' => $settings->get('auto_create_lookup_contact'),
      '#description' => $this->t('Automatically create a lookup contact when a user is created.'),
      '#states' => [
        'enabled' => [
          ':input[name="auto_create_crm_user_contact_mapping"]' => ['checked' => TRUE],
        ],
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $this->config('crm.user_contact_mapping.settings')
      ->set('display_name', $form_state->getValue('display_name'))
      ->set('auto_create_crm_user_contact_mapping', $form_state->getValue('auto_create_crm_user_contact_mapping'))
      ->set('auto_create_lookup_contact', $form_state->getValue('auto_create_lookup_contact'))
      ->save();

    return parent::submitForm($form, $form_state);
  }

}
