<?php

declare(strict_types=1);

namespace Drupal\crm\Hook;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hooks relating to contacts.
 */
class ContactHooks {

  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {}

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme() {
    return [
      'crm_contact' => [
        'render element' => 'elements',
      ],
      'crm_relationship' => [
        'render element' => 'elements',
      ],
    ];
  }

  /**
   * Implements hook_ENTITY_TYPE_delete().
   */
  #[Hook('crm_contact_delete')]
  public function crmContactDelete($contact) {
    $crm_user_contact_mappings = $this->entityTypeManager
      ->getStorage('crm_user_contact_mapping')
      ->loadByProperties(['crm_contact' => $contact->id()]);
    if ($crm_user_contact_mappings != NULL) {
      $crm_user_contact_mapping = reset($crm_user_contact_mappings);
      $crm_user_contact_mapping->delete();
    }
    // CRM Relationship.
    $relationship_storage = $this->entityTypeManager
      ->getStorage('crm_relationship');

    $query = $relationship_storage->getQuery();
    $query->condition('contacts', $contact->id());
    $query->accessCheck(FALSE);
    $relationship_ids = $query->execute();

    foreach ($relationship_ids as $relationship_id) {
      $relationship = $relationship_storage->load($relationship_id);
      $relationship->delete();
    }

    $contact_detail_lists = [];
    $contact_detail_lists[] = $contact->get('emails');
    $contact_detail_lists[] = $contact->get('telephones');
    $contact_detail_lists[] = $contact->get('addresses');

    $contact_detail_storage = $this->entityTypeManager
      ->getStorage('crm_contact_detail');
    foreach ($contact_detail_lists as $list) {
      $detail_entities = $list->referencedEntities();
      $contact_detail_storage->delete($detail_entities);
    }

  }

}
