<?php

declare(strict_types=1);

namespace Drupal\crm\Plugin\EntityReferenceSelection;

use Drupal\Core\Entity\Attribute\EntityReferenceSelection;
use Drupal\Core\Entity\Plugin\EntityReferenceSelection\DefaultSelection;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Filters contacts to only those specified in valid_contact_ids.
 */
#[EntityReferenceSelection(
  id: 'valid_contacts:crm_contact',
  label: new TranslatableMarkup('Valid Contacts: CRM Contact'),
  entity_types: ['crm_contact'],
  group: 'valid_contacts',
  weight: 0,
)]
class ValidContactsSelection extends DefaultSelection {

  /**
   * {@inheritdoc}
   */
  public function buildEntityQuery($match = NULL, $match_operator = 'CONTAINS') {
    $query = parent::buildEntityQuery($match, $match_operator);

    // Check if valid_contact_ids is set in configuration.
    if (!empty($this->configuration['valid_contact_ids'])) {
      $valid_ids = $this->configuration['valid_contact_ids'];
      // Ensure we have valid integers.
      $valid_ids = array_map('intval', $valid_ids);
      $valid_ids = array_filter($valid_ids);

      if (!empty($valid_ids)) {
        $query->condition('id', $valid_ids, 'IN');
      }
    }

    return $query;
  }

}
