<?php

namespace Drupal\crm\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks that relationship limits are not exceeded.
 */
#[Constraint(
  id: 'RelationshipLimit',
  label: new TranslatableMarkup('Relationship Limit', [], ['context' => 'Validation'])
)]
class RelationshipLimitConstraint extends SymfonyConstraint {

  /**
   * The message shown when the limit for Contact A is exceeded.
   *
   * @var string
   */
  public $limitExceededMessageA = 'This contact already has @count @type relationship(s) in the @label position. The maximum allowed is @limit.';

  /**
   * The message shown when the limit for Contact B is exceeded.
   *
   * @var string
   */
  public $limitExceededMessageB = 'This contact already has @count @type relationship(s) in the @label position. The maximum allowed is @limit.';

}
