<?php

namespace Drupal\crm\Plugin\views\query;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views\Attribute\ViewsQuery;
use Drupal\views\Plugin\views\query\QueryPluginBase;

/**
 * Views query plugin for a CRM user contact mapping.
 */
#[ViewsQuery(
  id: 'crm_user_contact_mapping',
  title: new TranslatableMarkup('User Contact Mapping'),
  help: new TranslatableMarkup('Mapping between the user and person.')
)]
class CrmUserContactMapping extends QueryPluginBase {

  /**
   * {@inheritdoc}
   */
  public function ensureTable($table, $relationship = NULL) {
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function addField($table, $field, $alias = '', $params = []) {
    return $field;
  }

}
