<?php

declare(strict_types=1);

namespace Drupal\crm\Service;

use Drupal\comment\CommentLazyBuilders as BaseCommentLazyBuilders;
use Drupal\comment\CommentManagerInterface;
use Drupal\Core\Entity\EntityFormBuilderInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Render\RendererInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Path\CurrentPathStack;
use Drupal\Core\Url;

/**
 * Custom comment lazy builders.
 */
class CommentLazyBuilders extends BaseCommentLazyBuilders {

  /**
   * The path current service.
   *
   * @var \Drupal\Core\Path\CurrentPathStack
   */
  protected $pathCurrent;

  /**
   * Constructs a new CommentLazyBuilders object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager service.
   * @param \Drupal\Core\Entity\EntityFormBuilderInterface $entity_form_builder
   *   The entity form builder service.
   * @param \Drupal\Core\Session\AccountInterface $current_user
   *   The current logged in user.
   * @param \Drupal\comment\CommentManagerInterface|null $comment_manager
   *   The comment manager service.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler service.
   * @param \Drupal\Core\Render\RendererInterface $renderer
   *   The renderer service.
   * @param \Drupal\Core\Path\CurrentPathStack $path_current
   *   The path current service.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager, EntityFormBuilderInterface $entity_form_builder, AccountInterface $current_user, ?CommentManagerInterface $comment_manager, ModuleHandlerInterface $module_handler, RendererInterface $renderer, CurrentPathStack $path_current) {
    parent::__construct($entity_type_manager, $entity_form_builder, $current_user, $comment_manager, $module_handler, $renderer);
    $this->pathCurrent = $path_current;
  }

  /**
   * {@inheritdoc}
   */
  public function renderForm($commented_entity_type_id, $commented_entity_id, $field_name, $comment_type_id) {
    $form = parent::renderForm($commented_entity_type_id, $commented_entity_id, $field_name, $comment_type_id);

    $current_path = $this->pathCurrent->getPath();
    $form['#action'] = Url::fromUserInput($form['#action'], [
      'query' => [
        'destination' => $current_path,
        'crm_contact' => $commented_entity_id,
      ],
    ])->toString();

    return $form;
  }

}
