<?php

namespace Drupal\crm;

use Drupal\Core\Entity\ContentEntityTypeInterface;
use Drupal\Core\Entity\Sql\SqlContentEntityStorageSchema;

/**
 * Defines the crm_user_contact_mapping schema handler.
 */
class UserContactMappingStorageSchema extends SqlContentEntityStorageSchema {

  /**
   * {@inheritdoc}
   */
  protected function getEntitySchema(ContentEntityTypeInterface $entity_type, $reset = FALSE) {
    $schema = parent::getEntitySchema($entity_type, $reset);
    $data_table = 'crm_user_contact_mapping';
    if (isset($schema[$data_table])) {

      if (!isset($schema[$data_table]['unique keys'])) {
        $schema[$data_table]['unique keys'] = [];
      }
      $schema[$data_table]['unique keys'] += [
        'crm_user_contact_mapping__user' => ['user'],
        'crm_user_contact_mapping__crm_contact' => ['crm_contact'],
      ];
      $schema[$data_table]['fields']['user']['not null'] = TRUE;
      $schema[$data_table]['fields']['crm_contact']['not null'] = TRUE;
    }

    return $schema;
  }

}
