<?php

declare(strict_types=1);

namespace Drupal\Tests\crm\Functional;

use Drupal\crm\Entity\UserContactMapping;
use Drupal\Tests\BrowserTestBase;

/**
 * Functional test for mapped contact permissions.
 *
 * @group crm
 */
class MappedContactPermissionTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['crm'];

  /**
   * The user s.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $user;

  /**
   * The contact with mapped contact permissions.
   *
   * @var \Drupal\crm\CrmContactInterface
   */
  protected $contact;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    // Create two users with mapped contact permissions.
    $permissions = [
      'view mapped crm_contact',
      'edit mapped crm_contact',
    ];
    $this->user = $this->drupalCreateUser($permissions);

    // Create a person contact.
    $this->contact = \Drupal::entityTypeManager()->getStorage('crm_contact')->create([
      'bundle' => 'person',
      'full_name' => ['given' => $this->randomMachineName(8)],
    ]);
    $this->contact->save();
  }

  /**
   * Tests view/edit mapped crm_contact permissions.
   */
  public function testMappedContactPermissions() {
    // Map the person to user1.
    $user_contact_mapping = UserContactMapping::create([
      'user' => $this->user->id(),
      'crm_contact' => $this->contact->id(),
    ]);
    $user_contact_mapping->save();

    // Login as user1.
    $this->drupalLogin($this->user);

    // View the contact.
    $this->drupalGet('crm/contact/' . $this->contact->id());
    $this->assertSession()->statusCodeEquals(200);

    // Edit the contact.
    $this->drupalGet('crm/contact/' . $this->contact->id() . '/edit');
    $this->assertSession()->statusCodeEquals(200);

  }

  /**
   * Tests view/edit for a user without mapped contact permissions.
   */
  public function testMappedContact() {

    // Login as user1.
    $this->drupalLogin($this->user);

    // View the contact.
    $this->drupalGet('crm/contact/' . $this->contact->id());
    $this->assertSession()->statusCodeEquals(403);

    // Edit the contact.
    $this->drupalGet('crm/contact/' . $this->contact->id() . '/edit');
    $this->assertSession()->statusCodeEquals(403);

  }

}
