<?php

declare(strict_types=1);

namespace Drupal\Tests\crm\Unit;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Routing\RedirectDestinationInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\crm\ContactDetailListBuilder;
use Drupal\Tests\UnitTestCase;

/**
 * Tests ContactDetailListBuilder functionality.
 *
 * @group crm
 * @coversDefaultClass \Drupal\crm\ContactDetailListBuilder
 */
class ContactDetailListBuilderTest extends UnitTestCase {

  /**
   * The list builder under test.
   *
   * @var \Drupal\crm\ContactDetailListBuilder
   */
  protected $listBuilder;

  /**
   * Mock entity type.
   *
   * @var \Drupal\Core\Entity\EntityTypeInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityType;

  /**
   * Mock entity storage.
   *
   * @var \Drupal\Core\Entity\EntityStorageInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $storage;

  /**
   * Mock contact storage.
   *
   * @var \Drupal\Core\Entity\EntityStorageInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $contactStorage;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->entityType = $this->createMock(EntityTypeInterface::class);
    $this->entityType->method('id')->willReturn('crm_contact_detail');
    $this->entityType->method('getKey')->willReturn('id');

    $this->storage = $this->createMock(EntityStorageInterface::class);
    $this->contactStorage = $this->createMock(EntityStorageInterface::class);

    // Set up the container with required services.
    $container = new ContainerBuilder();
    $moduleHandler = $this->createMock(ModuleHandlerInterface::class);
    $moduleHandler->method('invokeAll')->willReturn([]);
    $moduleHandler->method('alter')->willReturn(NULL);
    $container->set('module_handler', $moduleHandler);

    $redirectDestination = $this->createMock(RedirectDestinationInterface::class);
    $redirectDestination->method('getAsArray')->willReturn(['destination' => '/admin/content/crm/detail']);
    $container->set('redirect.destination', $redirectDestination);

    \Drupal::setContainer($container);

    $this->listBuilder = new ContactDetailListBuilder(
      $this->entityType,
      $this->storage,
      $this->contactStorage
    );

    // Set up string translation.
    $translation = $this->createMock(TranslationInterface::class);
    $translation->method('translateString')->willReturnCallback(
      function ($string) {
        return $string->getUntranslatedString();
      }
    );
    $this->listBuilder->setStringTranslation($translation);
  }

  /**
   * Tests buildHeader returns expected columns.
   *
   * @covers ::buildHeader
   */
  public function testBuildHeader(): void {
    $header = $this->listBuilder->buildHeader();

    $this->assertArrayHasKey('id', $header);
    $this->assertArrayHasKey('label', $header);
    $this->assertArrayHasKey('type', $header);
    $this->assertArrayHasKey('reference', $header);
    $this->assertArrayHasKey('status', $header);
    $this->assertArrayHasKey('created', $header);
    $this->assertArrayHasKey('changed', $header);
    $this->assertArrayHasKey('operations', $header);

    $this->assertEquals('ID', (string) $header['id']);
    $this->assertEquals('Label', (string) $header['label']);
    $this->assertEquals('Type', (string) $header['type']);
    $this->assertEquals('Reference', (string) $header['reference']);
    $this->assertEquals('Status', (string) $header['status']);
    $this->assertEquals('Created', (string) $header['created']);
    $this->assertEquals('Updated', (string) $header['changed']);
  }

}
