<?php

declare(strict_types=1);

namespace Drupal\Tests\crm\Unit;

use Drupal\Core\Database\Connection;
use Drupal\Core\Datetime\DateFormatterInterface;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Routing\RedirectDestinationInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\crm\UserContactMappingListBuilder;
use Drupal\Tests\UnitTestCase;

/**
 * Tests UserContactMappingListBuilder functionality.
 *
 * @group crm
 * @coversDefaultClass \Drupal\crm\UserContactMappingListBuilder
 */
class UserContactMappingListBuilderTest extends UnitTestCase {

  /**
   * The list builder under test.
   *
   * @var \Drupal\crm\UserContactMappingListBuilder
   */
  protected $listBuilder;

  /**
   * Mock entity type.
   *
   * @var \Drupal\Core\Entity\EntityTypeInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityType;

  /**
   * Mock entity storage.
   *
   * @var \Drupal\Core\Entity\EntityStorageInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $storage;

  /**
   * Mock date formatter.
   *
   * @var \Drupal\Core\Datetime\DateFormatterInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $dateFormatter;

  /**
   * Mock redirect destination.
   *
   * @var \Drupal\Core\Routing\RedirectDestinationInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $redirectDestination;

  /**
   * Mock database connection.
   *
   * @var \Drupal\Core\Database\Connection|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $database;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->entityType = $this->createMock(EntityTypeInterface::class);
    $this->entityType->method('id')->willReturn('crm_user_contact_mapping');
    $this->entityType->method('getKey')->willReturn('id');

    $this->storage = $this->createMock(EntityStorageInterface::class);
    $this->dateFormatter = $this->createMock(DateFormatterInterface::class);
    $this->redirectDestination = $this->createMock(RedirectDestinationInterface::class);
    $this->database = $this->createMock(Connection::class);

    // Set up the container with required services.
    $container = new ContainerBuilder();
    $moduleHandler = $this->createMock(ModuleHandlerInterface::class);
    $moduleHandler->method('invokeAll')->willReturn([]);
    $moduleHandler->method('alter')->willReturn(NULL);
    $container->set('module_handler', $moduleHandler);
    \Drupal::setContainer($container);

    $this->listBuilder = new UserContactMappingListBuilder(
      $this->entityType,
      $this->storage,
      $this->dateFormatter,
      $this->redirectDestination,
      $this->database
    );

    // Set up string translation.
    $translation = $this->createMock(TranslationInterface::class);
    $translation->method('translateString')->willReturnCallback(
      function ($string) {
        return $string->getUntranslatedString();
      }
    );
    $this->listBuilder->setStringTranslation($translation);
  }

  /**
   * Tests buildHeader returns expected columns.
   *
   * @covers ::buildHeader
   */
  public function testBuildHeader(): void {
    $header = $this->listBuilder->buildHeader();

    $this->assertArrayHasKey('id', $header);
    $this->assertArrayHasKey('user', $header);
    $this->assertArrayHasKey('crm_contact', $header);
    $this->assertArrayHasKey('operations', $header);

    $this->assertEquals('ID', (string) $header['id']);
    $this->assertEquals('User', (string) $header['user']);
    $this->assertEquals('Person', (string) $header['crm_contact']);
  }

}
