<?php

declare(strict_types=1);

namespace Drupal\crm\Entity\ContactDetail;

/**
 * A bundle class for crm_contact_detail entities.
 */
class AddressContactDetail extends ContactDetailBase {

  /**
   * {@inheritdoc}
   */
  public function label() {
    $type = parent::label();

    /** @var \Drupal\address\Plugin\Field\FieldType\AddressItem $address */
    $label = $this->get('address')->first();

    if ($type) {
      $label = "$type: $label";
    }

    return $label;
  }

}
