<?php

declare(strict_types=1);

namespace Drupal\crm\Entity\ContactDetail;

/**
 * A bundle class for crm_contact_detail entities.
 */
class EmailContactDetail extends ContactDetailBase {

  /**
   * {@inheritdoc}
   */
  public function label() {
    $type = parent::label();

    /** @var \Drupal\email\Plugin\Field\FieldType\EmailItem $email */
    $label = $this->get('email')->first()->value;

    if ($type) {
      $label = "$type: $label";
    }

    return $label;
  }

}
