<?php

namespace Drupal\crm\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Checks that Contact A and Contact B are different.
 */
#[Constraint(
  id: 'DifferentContacts',
  label: new TranslatableMarkup('Different Contacts', [], ['context' => 'Validation'])
)]
class DifferentContactsConstraint extends SymfonyConstraint {

  /**
   * The message shown when the constraint is violated.
   *
   * @var string
   */
  public $message = 'Contact A and Contact B must be different.';

}
