<?php

declare(strict_types=1);

namespace Drupal\crm\Field;

use Drupal\Core\TypedData\ComputedItemListTrait;
use Drupal\Core\Field\FieldItemList;
use Drupal\Core\Field\EntityReferenceFieldItemListInterface;

/**
 * Computed field for the contact in a relationship.
 */
class RelationshipContactsItemList extends FieldItemList implements EntityReferenceFieldItemListInterface {
  use ComputedItemListTrait;

  /**
   * {@inheritdoc}
   */
  protected function computeValue() {
    $field_name = $this->getName();
    $entity = $this->getEntity();

    $contacts = $entity->get('contacts')->getValue();
    $contact = NULL;

    if (!empty($contacts)) {

      $contact = $contacts[0]['target_id'] ?? NULL;
      if ($field_name === 'contact_b') {
        $contact = $contacts[1]['target_id'] ?? NULL;
      }
    }

    $this->list[0] = $this->createItem(0, ['target_id' => $contact]);
  }

  /**
   * {@inheritdoc}
   */
  public function setValue($values, $notify = TRUE) {

    if (!empty($values)) {
      $field_name = $this->getName();
      $entity = $this->getEntity();
      $contacts_field = $entity->get('contacts');

      // Get current contacts.
      $contacts = $contacts_field->getValue();

      // Determine which contact to update based on field name.
      $contact_index = ($field_name === 'contact_b') ? 1 : 0;

      // Ensure we have enough contacts in the array.
      while (count($contacts) <= $contact_index) {
        $contacts[] = ['target_id' => NULL];
      }

      // Update the appropriate contact.
      $contacts[$contact_index]['target_id'] = is_array($values) ? $values[0]['target_id'] : $values;

      // Set the updated contacts field.
      $contacts_field->setValue($contacts);
    }

    // Call parent to maintain normal field behavior.
    parent::setValue($values, $notify);
  }

  /**
   * {@inheritdoc}
   */
  public function referencedEntities() {
    $field_name = $this->getName();
    $entities = $this->getEntity()->get('contacts')->referencedEntities();

    if ($field_name === 'contact_b') {
      return isset($entities[1]) ? [$entities[1]] : [];
    }

    return isset($entities[0]) ? [$entities[0]] : [];
  }

}
