<?php

declare(strict_types=1);

namespace Drupal\crm\Hook;

use Drupal\comment\CommentInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Path\CurrentPathStack;
use Drupal\Core\Url;

/**
 * Hooks relating to contacts.
 */
class CommentHooks {

  public function __construct(
    protected RouteMatchInterface $currentRouteMatch,
    protected CurrentPathStack $pathCurrent,
  ) {}

  /**
   * Implements hook_comment_links_alter().
   */
  #[Hook('comment_links_alter')]
  public function commentLinksAlter(array &$links, CommentInterface $comment, array &$context) {
    $entity_type = $comment->getCommentedEntity()->getEntityTypeId();
    if ($entity_type !== 'crm_contact') {
      return;
    }
    $current_route = $this->currentRouteMatch->getRouteName();
    if ($current_route !== 'crm.contact.comment') {
      return;
    }

    $current_path = $this->pathCurrent->getPath();
    $destination = ['destination' => $current_path];

    foreach ($links['comment']['#links'] as &$link) {
      if (isset($link['url']) && $link['url'] instanceof Url) {
        $existing_options = $link['url']->getOptions();
        $link['url']->setOptions([
          'query' => ($existing_options['query'] ?? []) + $destination,
        ] + $existing_options);
      }
    }
  }

}
