<?php

namespace Drupal\crm\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\crm\Entity\ContactDetail\AddressContactDetail;
use Drupal\crm\Entity\ContactDetail\EmailContactDetail;
use Drupal\crm\Entity\ContactDetail\TelephoneContactDetail;

/**
 * Hooks relating to entities.
 */
class EntityHooks {

  /**
   * Implements hook_entity_bundle_info_alter().
   */
  #[Hook('entity_bundle_info_alter')]
  public function entityBundleInfoAlter(array &$bundles): void {
    if (isset($bundles['crm_contact_detail']['address'])) {
      $bundles['crm_contact_detail']['address']['class'] = AddressContactDetail::class;
    }
    if (isset($bundles['crm_contact_detail']['email'])) {
      $bundles['crm_contact_detail']['email']['class'] = EmailContactDetail::class;
    }
    if (isset($bundles['crm_contact_detail']['telephone'])) {
      $bundles['crm_contact_detail']['telephone']['class'] = TelephoneContactDetail::class;
    }
  }

  /**
   * Implements hook_inline_entity_form_table_fields_alter().
   */
  #[Hook('inline_entity_form_table_fields_alter')]
  public function inlineEntityFormTableFieldsAlter(&$fields, $context) {
    if ($context['parent_entity_type'] == 'crm_contact' && $context['entity_type'] == 'crm_contact_detail') {
      if ($context['allowed_bundles'] == ['address']) {
        $fields['label']['label'] = t('Address (line 1)');
      }
      elseif ($context['allowed_bundles'] == ['telephone']) {
        $fields['label']['label'] = t('Telephone');
      }
      elseif ($context['allowed_bundles'] == ['email']) {
        $fields['label']['label'] = t('Email');
      }
    }
  }

  /**
   * Implements hook_entity_view().
   */
  #[Hook('entity_view')]
  public function entityView(array &$build, EntityInterface $entity, $view_mode, $langcode) {
    $entity_type = $entity->getEntityTypeId();

    if ($entity_type === 'crm_relationship') {
      /** @var \Drupal\crm\Entity\Relationship $entity */
      $bundle = $entity->get('bundle')->entity;
      if (isset($build['contact_a'])) {
        $build['contact_a']['#title'] = $bundle->get('label_a');
      }
      if (isset($build['contact_b'])) {
        $build['contact_b']['#title'] = $bundle->get('label_b');
      }
    }

    if ($entity_type === 'crm_contact') {
      /** @var \Drupal\crm\Entity\Contact $entity */
      $contact_type = $entity->get('bundle')->entity;
      $date = $contact_type->get('date');

      // Customize start_date field label and description in display.
      if ($date && !empty($date['start_date']['label']) && isset($build['start_date'])) {
        $build['start_date']['#title'] = $date['start_date']['label'];
      }

      // Customize end_date field label and description in display.
      if ($date && !empty($date['end_date']['label']) && isset($build['end_date'])) {
        $build['end_date']['#title'] = $date['end_date']['label'];
      }
    }
  }

}
