<?php

namespace Drupal\crm\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates that Contact A and Contact B are different.
 */
class DifferentContactsConstraintValidator extends ConstraintValidator {

  /**
   * Validates the entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity being validated.
   * @param \Drupal\crm\Plugin\Validation\Constraint\DifferentContactsConstraint $constraint
   *   The constraint to validate against.
   */
  public function validate($entity, Constraint $constraint) {
    $contact_a = $entity->get('contact_a')->first() ? $entity->get('contact_a')->first()->target_id : NULL;
    $contact_b = $entity->get('contact_b')->first() ? $entity->get('contact_b')->first()->target_id : NULL;

    if ($contact_a && $contact_b && $contact_a === $contact_b) {
      $this->context->addViolation($constraint->message);
    }
  }

}
